library(tidyverse)

species <- "Fly"

clusterBed = str_c("/net/waterston/vol9/ChipSeqPipeline/All",species,"Peaks.TF.noDups.clusters.bed")  # all the clusters(metapeaks)
clusters <- read_tsv(clusterBed,col_names=FALSE)
clusters <- rename(clusters,chromo=X1,start=X2,end=X3,cluster=X4,nPeaks=X5,strand=X6,apexS=X7,apexE=X8,color=X9)

distBed <- str_c("/net/waterston/vol9/ChipSeqPipeline/All",species,"Peaks.TF.noDups.clustered.distance.bed") # primary targets of clustered peaks
distPeak <-  read_tsv(distBed,col_names=FALSE)
distPeak <- rename(distPeak,chromo=X1,start=X2,end=X3,exp=X4,score=X5,strand=X6,apexS=X7,apexE=X8,color=X9,
                   cluster=X10,target=X11,targetDist=X12)
distPeak <- mutate(distPeak,peakID=str_c(exp,chromo,start,":",end),absDist=abs(targetDist))
distPeak <- left_join(distPeak,clusters,by="cluster")

distClustBed <- str_c("/net/waterston/vol9/ChipSeqPipeline/All",species,"Peaks.TF.noDups.clusters.distance.bed") # primary targets of clusters
distClust <-  read_tsv(distClustBed,col_names=FALSE)


# minPeaks <- group_by(distPeak,peakID) %>% summarise(absDist=min(absDist))  
# minPeaks <- left_join(minPeaks,distPeak,by=c("peakID","absDist"))

altBed <- str_c("/net/waterston/vol9/ChipSeqPipeline/All",species,"Peaks.TF.noDups.clusters.altdist.bed") # alternate targets of clusters
altPeak <-  read_tsv(altBed,col_names=FALSE)
distPeak <- rename(distPeak,chromo=X1,start=X2,end=X3,exp=X4,score=X5,strand=X6,apexS=X7,apexE=X8,color=X9,
                   cluster=X10,target=X11,targetDist=X12)
distPeak <- mutate(distPeak,peakID=str_c(exp,chromo,start,":",end),absDist=abs(targetDist))
distPeak <- left_join(distPeak,clusters,by="cluster")


tssTSV <- str_c("/net/waterston/vol9/ChipSeqPipeline/All",species,"Peaks.TF.noDups.clustered.peakTSSs")
peakTSS <- read_tsv(tssTSV)
distPeak <- left_join(distPeak,peakTSS,by=c("target" = "TargetID"))
# minPeaks <- left_join(minPeaks,peakTSS,by=c("target" = "TargetID"))
# minPeaks <- distinct(minPeaks,peakID,.keep_all = TRUE)
saveRDS(distPeak,file=str_c("/net/waterston/vol6/",species,"TFPeaks_clusters_targets.rds"))























